/**
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { render } from 'lit';
import EventManager from '../utils/event-manager';
import { Default, Playground } from '../../src/components/tag/tag.stories';

const tagTemplate = () => Default();

const playgroundTemplate = (props?) =>
  Playground({
    'cds-tag': props,
  });

xdescribe('cds-tag', () => {
  describe('Enabling/disabling', () => {
    const events = new EventManager();

    it('should allow firing click event for normal condition', async () => {
      render(tagTemplate(), document.body);
      await Promise.resolve();
      const elem = document.querySelector('cds-tag');
      const spyClick = jasmine.createSpy('click');
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- https://github.com/carbon-design-system/carbon/issues/20452
      events.on(elem!, 'click', spyClick);
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- https://github.com/carbon-design-system/carbon/issues/20452
      elem!.shadowRoot!.querySelector('button')!.click();
      expect(spyClick).toHaveBeenCalled();
    });

    it('should disallow firing click event if disabled', async () => {
      render(playgroundTemplate({ disabled: true }), document.body);
      await Promise.resolve();
      const elem = document.querySelector('cds-tag');
      const spyClick = jasmine.createSpy('click');
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- https://github.com/carbon-design-system/carbon/issues/20452
      events.on(elem!, 'click', spyClick);
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- https://github.com/carbon-design-system/carbon/issues/20452
      elem!.shadowRoot!.querySelector('button')!.click();
      expect(spyClick).not.toHaveBeenCalled();
    });
  });

  afterEach(async () => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- https://github.com/carbon-design-system/carbon/issues/20452
    await render(undefined!, document.body);
  });
});
