/**
 * Copyright IBM Corp. 2020, 2022, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * Breakpoints for accordion items. It's different from one in `@carbon/layout` library.
 */
export enum ACCORDION_ITEM_BREAKPOINT {
  /**
   * Small breakpoint.
   */
  SMALL = 'sm',

  /**
   * Medium breakpoint.
   */
  MEDIUM = 'md',
}

/**
 * Accordion size.
 */
export enum ACCORDION_SIZE {
  /**
   * Small size.
   */
  SMALL = 'sm',

  /**
   * Medium size.
   */
  MEDIUM = 'md',

  /**
   * Large size.
   */
  LARGE = 'lg',
}

/**
 * Specify the alignment of the accordion heading title and chevron.
 */
export enum ACCORDION_ALIGNMENT {
  /**
   * Alignment to the start
   */
  START = 'start',

  /**
   * Alignment to the end
   */
  END = 'END',
}
