/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { TokenGroup } from './TokenGroup';

const color = TokenGroup.create({
  name: 'Color',
  properties: [],
  tokens: [
    'interactive-01',
    'interactive-02',
    'interactive-03',
    'interactive-04',
    'ui-background',
    'ui-01',
    'ui-02',
    'ui-03',
    'ui-04',
    'ui-05',
    'text-01',
    'text-02',
    'text-03',
    'text-04',
    'text-05',
    'text-error',
    'icon-01',
    'icon-02',
    'icon-03',
    'link-01',
    'link-02',
    'inverse-link',
    'field-01',
    'field-02',
    'inverse-01',
    'inverse-02',
    'support-01',
    'support-02',
    'support-03',
    'support-04',
    'inverse-support-01',
    'inverse-support-02',
    'inverse-support-03',
    'inverse-support-04',
    'overlay-01',
    'danger-01',
    'danger-02',
    'focus',
    'inverse-focus-ui',
    'hover-primary',
    'active-primary',
    'hover-primary-text',
    'hover-secondary',
    'active-secondary',
    'hover-tertiary',
    'active-tertiary',
    'hover-ui',
    'hover-light-ui',
    'hover-selected-ui',
    'active-ui',
    'active-light-ui',
    'selected-ui',
    'selected-light-ui',
    'inverse-hover-ui',
    'hover-danger',
    'active-danger',
    'hover-row',
    'visited-link',
    'disabled-01',
    'disabled-02',
    'disabled-03',
    'highlight',
    'decorative-01',
    'button-separator',
    'skeleton-01',
    'skeleton-02',
    // deprecated
    'brand-01',
    'brand-02',
    'brand-03',
    'active-01',
    'hover-field',
    'danger',
  ],
});

const type = TokenGroup.create({
  name: 'Type',
  properties: [],
  tokens: [
    'caption-01',
    'caption-02',
    'label-01',
    'label-02',
    'helper-text-01',
    'helper-text-02',
    'body-short-01',
    'body-long-01',
    'body-short-02',
    'body-long-02',
    'code-01',
    'code-02',
    'heading-01',
    'productive-heading-01',
    'heading-02',
    'productive-Heading-02',
    'productive-heading-03',
    'productive-heading-04',
    'productive-heading-05',
    'productive-heading-06',
    'productive-heading-07',
    'expressive-heading-01',
    'expressive-heading-02',
    'expressive-heading-03',
    'expressive-heading-04',
    'expressive-heading-05',
    'expressive-heading-06',
    'expressive-paragraph-01',
    'quotation-01',
    'quotation-02',
    'display-01',
    'display-02',
    'display-03',
    'display-04',
  ],
});

const layout = TokenGroup.create({
  name: 'Layout',
  properties: [],
  tokens: [
    'spacing-01',
    'spacing-02',
    'spacing-03',
    'spacing-04',
    'spacing-05',
    'spacing-06',
    'spacing-07',
    'spacing-08',
    'spacing-09',
    'spacing-10',
    'spacing-11',
    'spacing-12',
    'spacing-13',
    'layout-01',
    'layout-02',
    'layout-03',
    'layout-04',
    'layout-05',
    'layout-06',
    'layout-07',
    'fluid-spacing-01',
    'fluid-spacing-02',
    'fluid-spacing-03',
    'fluid-spacing-04',
    'container-01',
    'container-02',
    'container-03',
    'container-04',
    'container-05',
    'icon-size-01',
    'icon-size-02',
  ],
});

export const v10 = [
  ...color.getTokens().map((token) => {
    return {
      name: token.name,
      type: 'color',
    };
  }),
  ...type.getTokens().map((token) => {
    return {
      name: token.name,
      type: 'type',
    };
  }),
  ...layout.getTokens().map((token) => {
    return {
      name: token.name,
      type: 'layout',
    };
  }),
];
