/**
 * Copyright IBM Corp. 2022
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @jest-environment node
 */

'use strict';

const { SassRenderer } = require('@carbon/test-utils/scss');

const { render } = SassRenderer.create(__dirname);

describe('scss/components/fluid-date-picker', () => {
  test('Public API', async () => {
    const { unwrap } = await render(`
      @use 'sass:map';
      @use 'sass:meta';
      @use '../fluid-date-picker';

      $_: get('mixin', meta.mixin-exists('fluid-date-picker', 'fluid-date-picker'));
    `);
    expect(unwrap('mixin')).toBe(true);
  });
});
