/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @jest-environment node
 */

'use strict';

const { SassRenderer } = require('@carbon/test-utils/scss');

const { render } = SassRenderer.create(__dirname);

describe('@carbon/styles/scss/theme', () => {
  test('Public API', async () => {
    const { get } = await render(`
      @use 'sass:map';
      @use 'sass:meta';
      @use '../theme';

      $_: get('api', (
        variables: map.keys(meta.module-variables('theme')),
        mixins: (
          theme: meta.mixin-exists('theme', 'theme'),
        ),
      ));
    `);

    const { value: api } = get('api');
    expect(api.mixins).toEqual({
      theme: true,
    });
    expect(api.variables).toMatchInlineSnapshot(`
      [
        "fallback",
        "theme",
        "background",
        "background-active",
        "background-selected",
        "background-selected-hover",
        "background-hover",
        "background-brand",
        "background-inverse",
        "background-inverse-hover",
        "layer-01",
        "layer-active-01",
        "layer-background-01",
        "layer-hover-01",
        "layer-selected-01",
        "layer-selected-hover-01",
        "layer-02",
        "layer-active-02",
        "layer-background-02",
        "layer-hover-02",
        "layer-selected-02",
        "layer-selected-hover-02",
        "layer-03",
        "layer-active-03",
        "layer-background-03",
        "layer-hover-03",
        "layer-selected-03",
        "layer-selected-hover-03",
        "layer-selected-inverse",
        "layer-selected-disabled",
        "layer-accent-01",
        "layer-accent-active-01",
        "layer-accent-hover-01",
        "layer-accent-02",
        "layer-accent-active-02",
        "layer-accent-hover-02",
        "layer-accent-03",
        "layer-accent-active-03",
        "layer-accent-hover-03",
        "field-01",
        "field-hover-01",
        "field-02",
        "field-hover-02",
        "field-03",
        "field-hover-03",
        "interactive",
        "border-subtle-00",
        "border-subtle-01",
        "border-subtle-selected-01",
        "border-subtle-02",
        "border-subtle-selected-02",
        "border-subtle-03",
        "border-subtle-selected-03",
        "border-strong-01",
        "border-strong-02",
        "border-strong-03",
        "border-tile-01",
        "border-tile-02",
        "border-tile-03",
        "border-inverse",
        "border-interactive",
        "border-disabled",
        "text-primary",
        "text-secondary",
        "text-placeholder",
        "text-helper",
        "text-error",
        "text-inverse",
        "text-on-color",
        "text-on-color-disabled",
        "text-disabled",
        "link-primary",
        "link-primary-hover",
        "link-secondary",
        "link-inverse-visited",
        "link-visited",
        "link-inverse",
        "link-inverse-active",
        "link-inverse-hover",
        "icon-primary",
        "icon-secondary",
        "icon-inverse",
        "icon-on-color",
        "icon-on-color-disabled",
        "icon-disabled",
        "icon-interactive",
        "support-error",
        "support-success",
        "support-warning",
        "support-info",
        "support-error-inverse",
        "support-success-inverse",
        "support-warning-inverse",
        "support-info-inverse",
        "support-caution-major",
        "support-caution-minor",
        "support-caution-undefined",
        "syntax-comment",
        "syntax-line-comment",
        "syntax-block-comment",
        "syntax-doc-comment",
        "syntax-doc-string",
        "syntax-keyword",
        "syntax-operator-keyword",
        "syntax-control-keyword",
        "syntax-definition-keyword",
        "syntax-module-keyword",
        "syntax-variable",
        "syntax-name",
        "syntax-variable-name",
        "syntax-label-name",
        "syntax-attribute",
        "syntax-attribute-name",
        "syntax-property-name",
        "syntax-tag",
        "syntax-tag-name",
        "syntax-type",
        "syntax-type-name",
        "syntax-class-name",
        "syntax-namespace",
        "syntax-macro-name",
        "syntax-atom",
        "syntax-literal",
        "syntax-bool",
        "syntax-null",
        "syntax-self",
        "syntax-number",
        "syntax-integer",
        "syntax-float",
        "syntax-unit",
        "syntax-string",
        "syntax-character",
        "syntax-attribute-value",
        "syntax-special-string",
        "syntax-regexp",
        "syntax-escape",
        "syntax-url",
        "syntax-color",
        "syntax-operator",
        "syntax-deref-operator",
        "syntax-arithmetic-operator",
        "syntax-logic-operator",
        "syntax-bitwise-operator",
        "syntax-compare-operator",
        "syntax-update-operator",
        "syntax-definition-operator",
        "syntax-type-operator",
        "syntax-control-operator",
        "syntax-modifier",
        "syntax-punctuation",
        "syntax-separator",
        "syntax-bracket",
        "syntax-angle-bracket",
        "syntax-square-bracket",
        "syntax-paren",
        "syntax-brace",
        "syntax-content",
        "syntax-heading",
        "syntax-heading-1",
        "syntax-heading-2",
        "syntax-heading-3",
        "syntax-heading-4",
        "syntax-heading-5",
        "syntax-heading-6",
        "syntax-content-separator",
        "syntax-list",
        "syntax-quote",
        "syntax-emphasis",
        "syntax-strong",
        "syntax-monospace",
        "syntax-link",
        "syntax-strikethrough",
        "syntax-invalid",
        "syntax-meta",
        "syntax-document-meta",
        "syntax-annotation",
        "syntax-processing-instruction",
        "syntax-definition",
        "syntax-constant",
        "syntax-function",
        "syntax-standard",
        "syntax-local",
        "syntax-special",
        "ai-popover-background",
        "ai-popover-shadow-outer-01",
        "ai-popover-shadow-outer-02",
        "ai-inner-shadow",
        "ai-aura-start-sm",
        "ai-aura-start",
        "ai-aura-end",
        "ai-aura-hover-background",
        "ai-aura-hover-start",
        "ai-aura-hover-end",
        "ai-border-strong",
        "ai-border-start",
        "ai-border-end",
        "ai-drop-shadow",
        "ai-skeleton-background",
        "ai-skeleton-element-background",
        "ai-overlay",
        "ai-popover-caret-center",
        "ai-popover-caret-bottom",
        "ai-popover-caret-bottom-background",
        "ai-popover-caret-bottom-background-actions",
        "chat-prompt-background",
        "chat-prompt-border-start",
        "chat-prompt-border-end",
        "chat-prompt-text",
        "chat-bubble-user",
        "chat-bubble-user-text",
        "chat-bubble-agent",
        "chat-bubble-agent-text",
        "chat-bubble-border",
        "chat-avatar-bot",
        "chat-avatar-agent",
        "chat-avatar-user",
        "chat-shell-background",
        "chat-header-background",
        "chat-header-text",
        "chat-button",
        "chat-button-hover",
        "chat-button-text-hover",
        "chat-button-active",
        "chat-button-selected",
        "chat-button-text-selected",
        "highlight",
        "overlay",
        "color-scheme",
        "toggle-off",
        "shadow",
        "focus",
        "focus-inset",
        "focus-inverse",
        "skeleton-background",
        "skeleton-element",
        "layer",
        "layer-active",
        "layer-background",
        "layer-hover",
        "layer-selected",
        "layer-selected-hover",
        "layer-accent",
        "layer-accent-hover",
        "layer-accent-active",
        "field",
        "field-hover",
        "border-subtle",
        "border-subtle-selected",
        "border-strong",
        "border-tile",
      ]
    `);
  });
});
