/**
 * Copyright IBM Corp. 2021, 2025
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { usePrefix } from '../../internal/usePrefix';

interface SideNavDividerProps {
  /**
   * Provide an optional class to be applied to the containing node
   */
  className?: string;
}
const SideNavDivider = ({ className }: SideNavDividerProps) => {
  const prefix = usePrefix();
  const classNames = cx(`${prefix}--side-nav__divider`, className);
  return (
    <li className={classNames}>
      <hr />
    </li>
  );
};

SideNavDivider.propTypes = {
  /**
   * Provide an optional class to be applied to the containing node
   */
  className: PropTypes.string,
};

export default SideNavDivider;
