/**
 * Copyright IBM Corp. 2016, 2025
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import React, { useRef, useState } from 'react';
import ComposedModal, { ModalBody } from './ComposedModal';
import { ModalHeader } from './ModalHeader';
import { ModalFooter } from './ModalFooter';
import Select from '../Select';
import SelectItem from '../SelectItem';
import TextInput from '../TextInput';
import Button from '../Button';
import { FeatureFlags } from '../FeatureFlags';
import { Annotation } from '../../../.storybook/templates/Annotation';
import LinkTo from '@storybook/addon-links/react';
import { ClassPrefix } from '../ClassPrefix';
import './ComposedModalPresence.stories.scss';

export default {
  title: 'Components/ComposedModal/Feature Flags',
  component: ComposedModal,
  subcomponents: {
    ModalHeader,
    ModalBody,
    ModalFooter,
  },
  tags: ['!autodocs'],
};

export const EnablePresence = (args) => {
  const buttonRef = useRef(null);
  const [open, setOpen] = useState(true);
  return (
    <FeatureFlags enablePresence>
      <Annotation
        type="feature-flags"
        text={
          <span>
            This story is rendered with{' '}
            <LinkTo title="Getting Started/Feature Flags" name="Overview">
              enable-presence
            </LinkTo>{' '}
            enabled
          </span>
        }>
        <Button ref={buttonRef} onClick={() => setOpen(true)}>
          Launch composed modal
        </Button>
        <ClassPrefix prefix="presence">
          <div className="preview-modal-with-presence">
            <ComposedModal
              {...args}
              open={open}
              launcherButtonRef={buttonRef}
              onClose={() => setOpen(false)}>
              <ModalHeader
                label="Account resources"
                title="Add a custom domain"
                {...args}
              />
              <ModalBody>
                <p style={{ marginBottom: '1rem' }}>
                  Custom domains direct requests for your apps in this Cloud
                  Foundry organization to a URL that you own. A custom domain
                  can be a shared domain, a shared subdomain, or a shared domain
                  and host.
                </p>
                <TextInput
                  data-modal-primary-focus
                  id="text-input-1"
                  labelText="Domain name"
                  placeholder="e.g. github.com"
                  style={{ marginBottom: '1rem' }}
                />
                <Select
                  id="select-1"
                  defaultValue="us-south"
                  labelText="Region">
                  <SelectItem value="us-south" text="US South" />
                  <SelectItem value="us-east" text="US East" />
                </Select>
              </ModalBody>
              <ModalFooter
                primaryButtonText="Add"
                secondaryButtonText="Cancel"
                {...args}
              />
            </ComposedModal>
          </div>
        </ClassPrefix>
      </Annotation>
    </FeatureFlags>
  );
};
EnablePresence.storyName = 'enable-presence';
EnablePresence.argTypes = {
  children: {
    table: {
      disable: true,
    },
  },
  className: {
    table: {
      disable: true,
    },
  },
  containerClassName: {
    table: {
      disable: true,
    },
  },
  launcherButtonRef: {
    table: {
      disable: true,
    },
  },
  onClose: {
    action: 'onClose',
  },
  onKeyDown: {
    action: 'onKeyDown',
  },
  selectorPrimaryFocus: {
    table: {
      disable: true,
    },
  },
  selectorsFloatingMenus: {
    table: {
      disable: true,
    },
  },
};
