# Notes of globalization

- For simple components, translatable strings can be provided via React props.
  Click on "Show Info" button at the top right in each components' page in
  http://react.carbondesignsystem.com for more details.
- Some components have `translateWithId` props, that is API-compatible with
  [`react-i18next`](https://github.com/i18next/react-i18next) library. Search
  for
  [`translationIds`](https://github.com/IBM/carbon-components-react/search?q=translationIds&unscoped_q=translationIds)
  or
  [`translationKeys`](https://github.com/IBM/carbon-components-react/search?q=translationKeys&unscoped_q=translationKeys)
  to see the list of string IDs.
- Some components, e.g. `<AccordionItem>`, work as list items. They should be
  ordered with locale-specific sorting rules in mind.
- Some components, e.g. `<DataTable>`, support
  [custom sorting](../src/components/DataTable/README.md#custom-sorting). Such
  custom sorting logic should take locale-specific sorting rules into account.
- Date picker component relies on the G11N features in
  [`Flatpickr` library](https://chmln.github.io/flatpickr/). Set `locale` and
  `dateFormat` props to fully utilize `Flatpickr` library's G11N features. If
  you are using date/time in other components, make sure they are correctly
  formatted considering different formats in different locales.
- Styles provided through `@carbon/styles` (and therefore `@carbon/react` as
  well) use CSS logical properties and values for layout, which is impacted by
  the writing direction. This means that right-to-left styling is included out
  of the box. In previous versions of carbon packages, RTLCSS had to be used by
  consuming projects to output styles for right-to-left mode. RTLCSS is no
  longer needed now that logical properties are used. See more in the
  [original issue](https://github.com/carbon-design-system/carbon/issues/13619).
