/**
 * Copyright IBM Corp. 2016, 2026
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

const { test } = require('@playwright/test');
const { themes } = require('../../test-utils/env');
const { snapshotStory, visitStory } = require('../../test-utils/storybook');
const { snapshot } = require('../../test-utils/snapshot');

test.describe('Notifications', () => {
  themes.forEach((theme) => {
    test.describe(theme, () => {
      test('toast @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Toast',
          id: 'components-notifications-toast--default',
          theme,
        });
      });

      test('inline @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Inline',
          id: 'components-notifications-inline--default',
          theme,
        });
      });

      test('actionable @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Actionable',
          id: 'components-notifications-actionable--default',
          theme,
        });
      });

      test('actionable inline @vrt', async ({ page }) => {
        await visitStory(page, {
          component: 'Actionable',
          id: 'components-notifications-actionable--default',
          globals: {
            theme,
          },
          args: {
            inline: true,
          },
        });
        await snapshot(page, {
          component: 'Actionable',
          story: 'components-notifications-actionable--default-inline',
          theme,
        });
      });

      test('callout @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Callout',
          id: 'components-notifications-callout--default',
          theme,
        });
      });
    });
  });
});
