/**
 * Copyright IBM Corp. 2016, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

const { test } = require('@playwright/test');
const { themes } = require('../../test-utils/env');
const { snapshotStory } = require('../../test-utils/storybook');

test.describe('Dropdown', () => {
  themes.forEach((theme) => {
    test.describe(theme, () => {
      test('default @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Dropdown',
          id: 'components-dropdown--default',
          theme,
        });
      });

      test('inline @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Dropdown',
          id: 'components-dropdown--inline',
          theme,
        });
      });

      test('with layer @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Dropdown',
          id: 'components-dropdown--with-layer',
          theme,
        });
      });

      test('inline with layer @vrt', async ({ page }) => {
        await snapshotStory(page, {
          component: 'Dropdown',
          id: 'components-dropdown--inline-with-layer',
          theme,
        });
      });
    });
  });
});
