# Type

<!-- prettier-ignore-start -->
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Table of Contents

- [Type classes](#type-classes)
  - [Carbon](#carbon)
  - [IBM Design Language](#ibm-design-language)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
<!-- prettier-ignore-end -->

## Type classes

In v10 of the Carbon Design System, we introduced the idea of
[type styles](https://www.carbondesignsystem.com/guidelines/typography/overview#type-tokens-and-sets)
as a new type of token in the design system. These styles are intended to be
used in place of the type classes from v9. For example, if you had the following
snippet of HTML:

```html
<h1 class="bx--giga">Heading 1</h1>
```

In v10 of Carbon you would want to target this `<h1>` tag with a selector and
use the `type-style` mixin to include the token detailed in the migration table
below. For `bx--giga`, this would be the `productive-heading-07` token.

Following the example from above, you could update your HTML to become:

```html
<h1 class="page-title">Heading 1</h1>
```

And in your Sass, you can use the `type-style` mixin provided by Carbon:

```scss
.page-title {
  @include type-style(productive-heading-07);
}
```

### Carbon

| Type class | v9   | v10 token               | v10 value |
| ---------- | ---- | ----------------------- | --------- |
| Giga       | 76px | `productive-heading-07` | 54px      |
| Mega       | 54px | `productive-heading-06` | 42px      |
| Alpha      | 36px | `productive-heading-05` | 32px      |
| Beta       | 28px | `productive-heading-04` | 28px      |
| Gamma      | 20px | `productive-heading-03` | 20px      |
| Delta      | 18px | `productive-heading-03` | 20px      |
| Epsilon    | 16px | `productive-heading-02` | 16px      |
| Zeta       | 14px | `productive-heading-01` | 14px      |
| Omega      | 12px | N/A                     |           |
| Caption    | 12px | `caption-01`            | 12px      |
| Legal      | 11px | `caption-01`            | 12px      |
| Paragraph  | 16px | `body-long-02`          | 16px      |

### IBM Design Language

| Type class | Category  | Token                     |
| ---------- | --------- | ------------------------- |
| A          |           | `caption-01` / `label-01` |
| A Mono     |           | `code-01`                 |
| B Tight    |           | `body-short-01`           |
| B          |           | `body-long-01`            |
| C Tight    |           | `body-short-02`           |
| C          |           | `body-long-02`            |
| D          |           | `heading-02`              |
| E          | Product   | `heading-03`              |
| F          | Editorial | `expressive-heading-04`   |
| G\*        | Product   | `productive-heading-04`   |
| H\*        | Product   | `productive-heading-05`   |
| I          | Editorial | `display-01`              |
| I Serif    | Editorial | `quotation-02`            |
| J          | Editorial | `display-03`              |
| K          | Editorial | `display-04`              |
