# Themes

<!-- prettier-ignore-start -->
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Table of Contents

- [Usage](#usage)
- [Migrating](#migrating)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
<!-- prettier-ignore-end -->

## Usage

You can use the `@carbon/themes` package as a replacement for `carbon-themes`.
This package will provide all themes and color groups for the new version of the
IBM Design Language and Carbon v10.

You can use `@carbon/themes` by including the files in Sass, or JavaScript. For
full usage information, checkout the project
[`README.md`](../../packages/themes/README.md) file.

To include a theme in your Sass, you can write the following in your file:

```scss
@import '@carbon/themes/scss/themes';
```

By default this will load in the `white` color group in your theme. If you are
looking for a specific color group can import them directly by writing the
following:

```scss
@import '@carbon/themes/scss/g10';

@include carbon--theme-g10();
```

You can repeat this for any of the color groups, for example `white`, `g10`,
`g90`, and `g100`.

## Migrating

The `carbon-themes` package has been deprecated, instead you should use the
`@carbon/themes` package.

Below is a list of all the `themes` files that existed in v9 and their
replacement in the newest version.

| v9                                | v10                                 |
| --------------------------------- | ----------------------------------- |
| `themes/carbon.scss`              | Replaced by the `white` color group |
| `themes/dark-ui.scss`             | Replaced by the `g90` color group   |
| `themes/experimental--light.scss` | Replaced by the `white` color group |
| `themes/genesis.scss`             | Removed                             |
| `themes/watson.scss`              | Removed                             |
