<p align="center">
  <a href="https://www.carbondesignsystem.com">
    <img alt="Carbon Design System" src="https://user-images.githubusercontent.com/3901764/57545698-ce5f2380-7320-11e9-8682-903df232d7b0.png" width="100%" />
  </a>
</p>
<h1 align="center">
  Carbon Design System
</h1>

> Carbon is an open-source design system built by IBM. With the IBM Design
> Language as its foundation, the system consists of working code, design tools
> and resources, human interface guidelines, and a vibrant community of
> contributors.

<p align="center">
  <a href="https://github.com/carbon-design-system/carbon/blob/master/LICENSE">
    <img src="https://img.shields.io/badge/license-Apache--2.0-blue.svg" alt="Carbon is released under the Apache-2.0 license" />
  </a>
  <a href="https://github.com/carbon-design-system/carbon/actions/workflows/ci.yml">
    <img src="https://github.com/carbon-design-system/carbon/actions/workflows/ci.yml/badge.svg" alt="CI workflow status" />
  </a>
  <a href="https://lerna.js.org/">
    <img src="https://img.shields.io/badge/maintained%20with-lerna-cc00ff.svg" alt="Maintained with Lerna" />
  </a>
  <a href="https://github.com/carbon-design-system/carbon/blob/master/.github/CONTRIBUTING.md">
    <img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg" alt="PRs welcome" />
  </a>
  <a href="https://bestpractices.coreinfrastructure.org/projects/7034">
    <img src="https://bestpractices.coreinfrastructure.org/projects/7034/badge">
  </a>
  <a href="https://discord.gg/J7JEUEkTRX">
    <img src="https://img.shields.io/discord/689212587170201628?color=5865F2" alt="Chat with us on Discord">
  </a>
</p>

## Getting started

If you're just getting started, check out [`@carbon/react`](./packages/react) or
[`@carbon/web-components`](./packages/web-components).

We also have community-contributed components for the following technologies:

- [Angular](https://github.com/IBM/carbon-components-angular)
- [Svelte](https://github.com/IBM/carbon-components-svelte)
- [Vue](https://github.com/carbon-design-system/carbon-components-vue)

If you're trying to find something specific, here's a full list of packages that
we support!

| Package name                                          | Description                                                                                                                                                                                                                                   |
| ----------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [`@carbon/react`](./packages/react)                   | React components and styles                                                                                                                                                                                                                   |
| [`@carbon/web-components`](./packages/web-components) | Web Components                                                                                                                                                                                                                                |
| [`@carbon/styles`](./packages/styles)                 | Sass styles for components                                                                                                                                                                                                                    |
| [`@carbon/elements`](./packages/elements)             | IBM Design Language elements like colors, type, iconography, and more                                                                                                                                                                         |
| [`@carbon/colors`](./packages/colors)                 | Work with IBM Design Language colors                                                                                                                                                                                                          |
| [`@carbon/grid`](./packages/grid)                     | Build layouts using the new 16 column grid system                                                                                                                                                                                             |
| [`@carbon/icons`](./packages/icons)                   | Iconography assets. We also offer support in: [React](./packages/icons-react), [Angular](https://github.com/carbon-design-system/carbon-icons-angular), [Vue](./packages/icons-vue), and [Svelte](https://github.com/IBM/carbon-icons-svelte) |
| [`@carbon/pictograms`](./packages/pictograms)         | Pictogram assets. We also offer support in: [React](./packages/pictograms-react) and [Svelte](https://github.com/IBM/carbon-pictograms-svelte)                                                                                                |
| [`@carbon/layout`](./packages/layout)                 | Layout-based units and spacing scale                                                                                                                                                                                                          |
| [`@carbon/motion`](./packages/motion)                 | Productive and expressive motion curves                                                                                                                                                                                                       |
| [`@carbon/themes`](./packages/themes)                 | Color tokens available in the Carbon Design System, like `$interactive-01`                                                                                                                                                                    |
| [`@carbon/type`](./packages/type)                     | New type tokens used alongside IBM Plex                                                                                                                                                                                                       |

> [!NOTE]
>
> The code for https://carbondesignsystem.com/ is in
> https://github.com/carbon-design-system/carbon-website. Any issues or pull
> requests related to the website should be made there.

## :books: Documentation

- See our documentation site
  [here](https://www.carbondesignsystem.com/developing/frameworks/react/) for
  full how-to docs and guidelines
- [Contributing](/.github/CONTRIBUTING.md): Guidelines for making contributions
  to this repo.
- 🏃‍♀️ Migration Guides
  - [v10 to v11](./docs/migration/v11.md)
  - [v9 to v10 (vanilla)](./packages/carbon-components/docs/migration/migrate-to-10.x.md)
  - [v9 to v10 (v6 to v7 React)](./packages/react/docs/migration/migrate-to-7.x.md)

## 🙌 Contributing

We're always looking for contributors to help us fix bugs, build new features,
or help us improve the project documentation. If you're interested, definitely
check out our [Contributing Guide](/.github/CONTRIBUTING.md) and our
[Developer Guide](./docs/developer-handbook.md)! 👀

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/tay1orjones"><img src="https://avatars0.githubusercontent.com/u/3360588?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Taylor Jones</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=tay1orjones" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=tay1orjones" title="Documentation">📖</a> <a href="#a11y-tay1orjones" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/tw15egan"><img src="https://avatars1.githubusercontent.com/u/11928039?v=4?s=100" width="100px;" alt=""/><br /><sub><b>TJ Egan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=tw15egan" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=tw15egan" title="Documentation">📖</a> <a href="#infra-tw15egan" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Atw15egan" title="Reviewed Pull Requests">👀</a> <a href="#a11y-tw15egan" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/aledavila"><img src="https://avatars2.githubusercontent.com/u/12533409?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alessandra Davila</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=aledavila" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=aledavila" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Aaledavila" title="Reviewed Pull Requests">👀</a> <a href="#a11y-aledavila" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/andrea-cardona-b647594b/"><img src="https://avatars2.githubusercontent.com/u/32720851?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Andrea N. Cardona</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=andreancardona" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=andreancardona" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Aandreancardona" title="Reviewed Pull Requests">👀</a> <a href="#a11y-andreancardona" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/francinelucca"><img src="https://avatars.githubusercontent.com/u/40550942?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Francine Lucca</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=francinelucca" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=francinelucca" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Afrancinelucca" title="Reviewed Pull Requests">👀</a> <a href="#a11y-francinelucca" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/sstrubberg"><img src="https://avatars2.githubusercontent.com/u/15822070?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Scott Strubberg</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sstrubberg" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=sstrubberg" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Asstrubberg" title="Reviewed Pull Requests">👀</a> <a href="#a11y-sstrubberg" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/alisonjoseph"><img src="https://avatars0.githubusercontent.com/u/2753488?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alison Joseph</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=alisonjoseph" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=alisonjoseph" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Aalisonjoseph" title="Reviewed Pull Requests">👀</a> <a href="#a11y-alisonjoseph" title="Accessibility">️️️️♿️</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/aagonzales"><img src="https://avatars3.githubusercontent.com/u/11670886?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anna Gonzales</b></sub></a><br /><a href="#design-aagonzales" title="Design">🎨</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Aaagonzales" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/laurenmrice"><img src="https://avatars3.githubusercontent.com/u/43969356?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lauren Rice</b></sub></a><br /><a href="#design-laurenmrice" title="Design">🎨</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Alaurenmrice" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/joshblack"><img src="https://avatars1.githubusercontent.com/u/3901764?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Josh Black</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=joshblack" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=joshblack" title="Documentation">📖</a> <a href="#infra-joshblack" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Ajoshblack" title="Reviewed Pull Requests">👀</a> <a href="#a11y-joshblack" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://dakahn.netlify.com/"><img src="https://avatars3.githubusercontent.com/u/40970507?v=4?s=100" width="100px;" alt=""/><br /><sub><b>DAK</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=dakahn" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=dakahn" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Adakahn" title="Reviewed Pull Requests">👀</a> <a href="#a11y-dakahn" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/jnm2377"><img src="https://avatars0.githubusercontent.com/u/32556167?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Josefina Mancilla</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jnm2377" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=jnm2377" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Ajnm2377" title="Reviewed Pull Requests">👀</a> <a href="#a11y-jnm2377" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/emyarod"><img src="https://avatars3.githubusercontent.com/u/8265238?v=4?s=100" width="100px;" alt=""/><br /><sub><b>emyarod</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=emyarod" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=emyarod" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Aemyarod" title="Reviewed Pull Requests">👀</a> <a href="#a11y-emyarod" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/preetibansalui"><img src="https://avatars.githubusercontent.com/u/146315451?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Preeti Bansal</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=preetibansalui" title="Code">💻</a> <a href="#a11y-preetibansalui" title="Accessibility">️️️️♿️</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/erifsx"><img src="https://avatars3.githubusercontent.com/u/997572?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Eric Marcoux</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=erifsx" title="Code">💻</a></td>
    <td align="center"><a href="https://www.vincepic.one/"><img src="https://avatars1.githubusercontent.com/u/4078018?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vince Picone</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=vpicone" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=vpicone" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Avpicone" title="Reviewed Pull Requests">👀</a> <a href="#a11y-vpicone" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/jillianhowarth"><img src="https://avatars0.githubusercontent.com/u/20690344?v=4?s=100" width="100px;" alt=""/><br /><sub><b>jillianhowarth</b></sub></a><br /><a href="#content-jillianhowarth" title="Content">🖋</a> <a href="#design-jillianhowarth" title="Design">🎨</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Ajillianhowarth" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="http://turpialcreative/"><img src="https://avatars0.githubusercontent.com/u/4718579?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ricardo Henriquez</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=rjhenriquez" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=rjhenriquez" title="Documentation">📖</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Arjhenriquez" title="Reviewed Pull Requests">👀</a> <a href="#a11y-rjhenriquez" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/johnbister"><img src="https://avatars3.githubusercontent.com/u/70543333?v=4?s=100" width="100px;" alt=""/><br /><sub><b>johnbister</b></sub></a><br /><a href="#design-johnbister" title="Design">🎨</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Ajohnbister" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/dbrugger"><img src="https://avatars1.githubusercontent.com/u/10086178?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dominik Brugger</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=dbrugger" title="Code">💻</a> <a href="#maintenance-dbrugger" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://janhassel.de/"><img src="https://avatars2.githubusercontent.com/u/28265588?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jan Hassel</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=janhassel" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=janhassel" title="Documentation">📖</a> <a href="#a11y-janhassel" title="Accessibility">️️️️♿️</a> <a href="#design-janhassel" title="Design">🎨</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/AlexanderLyon"><img src="https://avatars0.githubusercontent.com/u/17458641?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alexander Lyon</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=AlexanderLyon" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/rzhekova"><img src="https://avatars2.githubusercontent.com/u/35401262?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rosie Z</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=rzhekova" title="Code">💻</a></td>
    <td align="center"><a href="https://nishithp.live/"><img src="https://avatars3.githubusercontent.com/u/34577844?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nishith P</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=NishithP2004" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/echarpibm"><img src="https://avatars2.githubusercontent.com/u/22177887?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Eric Charpentier</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=echarpibm" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/luizamendes"><img src="https://avatars0.githubusercontent.com/u/31076607?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Luiza Mendes</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=luizamendes" title="Code">💻</a> <a href="#maintenance-luizamendes" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/akmalhakimi1991"><img src="https://avatars0.githubusercontent.com/u/10990690?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Akmal Hakimi Mohd Zamri</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=akmalhakimi1991" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/sanjitbauli"><img src="https://avatars1.githubusercontent.com/u/272230?v=4?s=100" width="100px;" alt=""/><br /><sub><b>sanjitbauli</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sanjitbauli" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/moczolaszlo"><img src="https://avatars0.githubusercontent.com/u/3605657?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Laszlo Moczo</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=moczolaszlo" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/LMapes"><img src="https://avatars3.githubusercontent.com/u/56092796?v=4?s=100" width="100px;" alt=""/><br /><sub><b>LMapes</b></sub></a><br /><a href="#content-LMapes" title="Content">🖋</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=LMapes" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/conradennis"><img src="https://avatars1.githubusercontent.com/u/16782944?v=4?s=100" width="100px;" alt=""/><br /><sub><b>conradennis</b></sub></a><br /><a href="#design-conradennis" title="Design">🎨</a></td>
    <td align="center"><a href="https://github.com/metonym"><img src="https://avatars0.githubusercontent.com/u/10718366?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Eric Liu</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=metonym" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=metonym" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/rvsia"><img src="https://avatars0.githubusercontent.com/u/32869456?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Richard Všianský</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=rvsia" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/lee-chase"><img src="https://avatars0.githubusercontent.com/u/15086604?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lee Chase</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=lee-chase" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=lee-chase" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/GoldenFishe"><img src="https://avatars3.githubusercontent.com/u/29215242?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anton</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=GoldenFishe" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/panpan-lin"><img src="https://avatars0.githubusercontent.com/u/22054715?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Panpan Lin</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=panpan-lin" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/ashharrison90"><img src="https://avatars0.githubusercontent.com/u/20999846?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ashley Harrison</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ashharrison90" title="Code">💻</a></td>
    <td align="center"><a href="https://jendowns.com/"><img src="https://avatars0.githubusercontent.com/u/9057921?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jen Downs</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jendowns" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=jendowns" title="Documentation">📖</a> <a href="#a11y-jendowns" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="http://abdul-sen.github.io/portfolio"><img src="https://avatars2.githubusercontent.com/u/38502132?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Abdul Rehman</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Abdul-Sen" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/dudley-ibm"><img src="https://avatars1.githubusercontent.com/u/54119397?v=4?s=100" width="100px;" alt=""/><br /><sub><b>MIchael Dudley</b></sub></a><br /><a href="#design-dudley-ibm" title="Design">🎨</a></td>
    <td align="center"><a href="https://davidbradshaw.us/"><img src="https://avatars1.githubusercontent.com/u/8028956?v=4?s=100" width="100px;" alt=""/><br /><sub><b>David Bradshaw</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=dabrad26" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/SimonFinney"><img src="https://avatars2.githubusercontent.com/u/3846874?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Simon Finney</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=SimonFinney" title="Code">💻</a> <a href="#a11y-SimonFinney" title="Accessibility">️️️️♿️</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/atikenny"><img src="https://avatars2.githubusercontent.com/u/6061509?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Attila Bartha</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=atikenny" title="Code">💻</a></td>
    <td align="center"><a href="https://baeharam.netlify.com/"><img src="https://avatars0.githubusercontent.com/u/35518072?v=4?s=100" width="100px;" alt=""/><br /><sub><b>배하람</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=baeharam" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Yohanna"><img src="https://avatars0.githubusercontent.com/u/6926228?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Yohanna Gadelrab</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Yohanna" title="Documentation">📖</a></td>
    <td align="center"><a href="https://asudoh.github.io/"><img src="https://avatars1.githubusercontent.com/u/1259051?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Akira Sudoh</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=asudoh" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=asudoh" title="Documentation">📖</a> <a href="#a11y-asudoh" title="Accessibility">️️️️♿️</a> <a href="#infra-asudoh" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    <td align="center"><a href="https://github.com/oyin-k"><img src="https://avatars2.githubusercontent.com/u/22506709?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Oyinkan Oyetunmibi </b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=oyin-k" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/pbenson322"><img src="https://avatars1.githubusercontent.com/u/59934268?v=4?s=100" width="100px;" alt=""/><br /><sub><b>pbenson322</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=pbenson322" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/abbeyhrt"><img src="https://avatars2.githubusercontent.com/u/17281178?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Abbey Hart</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=abbeyhrt" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=abbeyhrt" title="Documentation">📖</a> <a href="#a11y-abbeyhrt" title="Accessibility">️️️️♿️</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/lucasmccomb"><img src="https://avatars0.githubusercontent.com/u/5007314?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lucas</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=lucasmccomb" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/dylanklohr"><img src="https://avatars0.githubusercontent.com/u/17390173?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dylan Klohr</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=dylanklohr" title="Documentation">📖</a></td>
    <td align="center"><a href="http://gilli.is/"><img src="https://avatars3.githubusercontent.com/u/5390864?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Gilli Sigurdsson</b></sub></a><br /><a href="#design-gillisig" title="Design">🎨</a></td>
    <td align="center"><a href="https://github.com/kennylam"><img src="https://avatars2.githubusercontent.com/u/909118?v=4?s=100" width="100px;" alt=""/><br /><sub><b>kennylam</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=kennylam" title="Code">💻</a> <a href="#a11y-kennylam" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/sgregoire"><img src="https://avatars3.githubusercontent.com/u/3350530?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sébastien</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sgregoire" title="Code">💻</a></td>
    <td align="center"><a href="http://dusanmilko.com/"><img src="https://avatars3.githubusercontent.com/u/302239?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dusan Milko</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=DusanMilko" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/taraspolovyi"><img src="https://avatars2.githubusercontent.com/u/25744197?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Taras Polovyi</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=taraspolovyi" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/chrisconnors-ibm"><img src="https://avatars3.githubusercontent.com/u/35537391?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Chris Connors</b></sub></a><br /><a href="#design-chrisconnors-ibm" title="Design">🎨</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=chrisconnors-ibm" title="Documentation">📖</a></td>
    <td align="center"><a href="http://www.david-conner.com/"><img src="https://avatars2.githubusercontent.com/u/1590966?v=4?s=100" width="100px;" alt=""/><br /><sub><b>David Conner</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=davidicus" title="Code">💻</a> <a href="#a11y-davidicus" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/code-blooded-developer"><img src="https://avatars0.githubusercontent.com/u/7156129?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Harish Mohanani</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=code-blooded-developer" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/FrivalszkyP"><img src="https://avatars1.githubusercontent.com/u/3766124?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Frivalszky-Mayer Péter</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=FrivalszkyP" title="Code">💻</a> <a href="#a11y-FrivalszkyP" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/s100"><img src="https://avatars1.githubusercontent.com/u/9932290?v=4?s=100" width="100px;" alt=""/><br /><sub><b>s100</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=s100" title="Code">💻</a></td>
    <td align="center"><a href="http://www.virk.cc/"><img src="https://avatars1.githubusercontent.com/u/3311536?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Taranveer Virk</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=virkt25" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ikhnaton"><img src="https://avatars0.githubusercontent.com/u/4853273?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Niall Cargill</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ikhnaton" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/asfordmatt"><img src="https://avatars2.githubusercontent.com/u/14233261?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Matt Chapman</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=asfordmatt" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/munkurious"><img src="https://avatars0.githubusercontent.com/u/2187109?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Boston Cartwright</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=munkurious" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/DavidSCChen"><img src="https://avatars1.githubusercontent.com/u/54974983?v=4?s=100" width="100px;" alt=""/><br /><sub><b>DavidSCChen</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=DavidSCChen" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/molyholy"><img src="https://avatars2.githubusercontent.com/u/77503726?v=4?s=100" width="100px;" alt=""/><br /><sub><b>molyholy</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=molyholy" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/scottdickerson"><img src="https://avatars.githubusercontent.com/u/6663002?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Scott Dickerson</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=scottdickerson" title="Code">💻</a></td>
    <td align="center"><a href="https://start.reactwarriors.com/join"><img src="https://avatars.githubusercontent.com/u/15031623?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Evgeniy Podgaetskiy</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=epodgaetskiy" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/CassidyJensen"><img src="https://avatars.githubusercontent.com/u/45407808?v=4?s=100" width="100px;" alt=""/><br /><sub><b>CassidyJensen</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=CassidyJensen" title="Code">💻</a> <a href="#a11y-CassidyJensen" title="Accessibility">️️️️♿️</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/lattmann"><img src="https://avatars.githubusercontent.com/u/1108945?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Zsolt Lattmann</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=lattmann" title="Code">💻</a></td>
    <td align="center"><a href="https://conrad.codes/"><img src="https://avatars.githubusercontent.com/u/3808948?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Conrad Schmidt</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ConradSchmidt" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/IgnacioBecerra"><img src="https://avatars.githubusercontent.com/u/24970122?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ignacio Becerra</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=IgnacioBecerra" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/swapnilpatil21"><img src="https://avatars.githubusercontent.com/u/46713873?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Swapnil Patil</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=swapnilpatil21" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/sophiiae"><img src="https://avatars.githubusercontent.com/u/18622886?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Fei Z</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sophiiae" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/IgnasA"><img src="https://avatars.githubusercontent.com/u/7099068?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ignas Ausiejus</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=IgnasA" title="Documentation">📖</a></td>
    <td align="center"><a href="https://ryanomackey.com/"><img src="https://avatars.githubusercontent.com/u/17710824?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ryan O. Mackey</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ryanomackey" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://www.skateman.eu/"><img src="https://avatars.githubusercontent.com/u/649130?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dávid Halász</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=skateman" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/guigueb"><img src="https://avatars1.githubusercontent.com/u/5973642?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Bill Guigue</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=guigueb" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/szymonbrandys"><img src="https://avatars.githubusercontent.com/u/79149899?v=4?s=100" width="100px;" alt=""/><br /><sub><b>szymonbrandys</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=szymonbrandys" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/adamalston"><img src="https://avatars.githubusercontent.com/u/18297826?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Adam Alston</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=adamalston" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/Kiittyka"><img src="https://avatars.githubusercontent.com/u/41021851?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Krithika S Udupa</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Kiittyka" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/egriff38"><img src="https://avatars.githubusercontent.com/u/6627718?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Eshin Griffith</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=egriff38" title="Code">💻</a></td>
    <td align="center"><a href="https://riantavares.github.io/"><img src="https://avatars.githubusercontent.com/u/8935295?v=4?s=100" width="100px;" alt=""/><br /><sub><b>@RianTavaresOn</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=RianTavares" title="Code">💻</a> <a href="#design-RianTavares" title="Design">🎨</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/ColbyJohnIBM"><img src="https://avatars.githubusercontent.com/u/19613692?v=4?s=100" width="100px;" alt=""/><br /><sub><b>ColbyJohnIBM</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ColbyJohnIBM" title="Code">💻</a></td>
    <td align="center"><a href="https://haakon.dev/"><img src="https://avatars.githubusercontent.com/u/1190770?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Håkon</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=imp-dance" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=imp-dance" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/TannerS"><img src="https://avatars.githubusercontent.com/u/8866319?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Tanner Summers</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=TannerS" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/motou"><img src="https://avatars.githubusercontent.com/u/1215956?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Zhen Wang</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=motou" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=motou" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/Kman316"><img src="https://avatars.githubusercontent.com/u/25666525?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Cathal Kenneally</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Kman316" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/dezkareid"><img src="https://avatars.githubusercontent.com/u/1269896?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Joel Humberto Gómez Paredes</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=dezkareid" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/NashJames"><img src="https://avatars.githubusercontent.com/u/37304960?v=4?s=100" width="100px;" alt=""/><br /><sub><b>James Nash</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=NashJames" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=NashJames" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://jakubfaliszewski.github.io/portfolio/"><img src="https://avatars.githubusercontent.com/u/25402419?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jakub Faliszewski</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jakubfaliszewski" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/gptt916"><img src="https://avatars3.githubusercontent.com/u/20601623?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nick Gong</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=gptt916" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/hannelevaltanen"><img src="https://avatars.githubusercontent.com/u/26527460?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hannele Valtanen</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=hannelevaltanen" title="Code">💻</a></td>
    <td align="center"><a href="https://61130061.github.io/llam4u-terminal/"><img src="https://avatars.githubusercontent.com/u/54393468?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Llam4u</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=61130061" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/issues?q=author%3A61130061" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://torresga.github.io/"><img src="https://avatars.githubusercontent.com/u/6892410?v=4?s=100" width="100px;" alt=""/><br /><sub><b>G. Torres</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=torresga" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/FionaDL"><img src="https://avatars.githubusercontent.com/u/28625558?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Fiona</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=FionaDL" title="Code">💻</a></td>
    <td align="center"><a href="https://lewisdavanzo.com/"><img src="https://avatars.githubusercontent.com/u/70274722?v=4?s=100" width="100px;" alt=""/><br /><sub><b>kindoflew</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=kindoflew" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/mgueyraud"><img src="https://avatars.githubusercontent.com/u/9916318?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mario Gueyraud</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mgueyraud" title="Code">💻</a></td>
    <td align="center"><a href="https://velog.io/@djunnni"><img src="https://avatars.githubusercontent.com/u/49237205?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dongjoon Lee</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Djunnni" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Shankar-CodeJunkie"><img src="https://avatars.githubusercontent.com/u/56068832?v=4?s=100" width="100px;" alt=""/><br /><sub><b>ShankarV-CodeJunkie</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Shankar-CodeJunkie" title="Code">💻</a></td>
    <td align="center"><a href="http://darioplatania.github.io/"><img src="https://avatars.githubusercontent.com/u/11682859?v=4?s=100" width="100px;" alt=""/><br /><sub><b>dario platania</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=darioplatania" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/matkrzy"><img src="https://avatars.githubusercontent.com/u/14991661?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mateusz Krzyżanowski</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=matkrzy" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jpsorensen"><img src="https://avatars.githubusercontent.com/u/93107699?v=4?s=100" width="100px;" alt=""/><br /><sub><b>jpsorensen</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jpsorensen" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jkap"><img src="https://avatars.githubusercontent.com/u/224587?v=4?s=100" width="100px;" alt=""/><br /><sub><b>jae kaplan</b></sub></a><br /><a href="#infra-jkap" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/sierrawetmore"><img src="https://avatars.githubusercontent.com/u/107062203?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sierra Wetmore</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sierrawetmore" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/kcprevatt"><img src="https://avatars.githubusercontent.com/u/68609306?v=4?s=100" width="100px;" alt=""/><br /><sub><b>kcprevatt</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=kcprevatt" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/lewandom"><img src="https://avatars.githubusercontent.com/u/8779205?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Marcin Lewandowski</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=lewandom" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/remolueoend"><img src="https://avatars.githubusercontent.com/u/7881606?v=4?s=100" width="100px;" alt=""/><br /><sub><b>remolueoend</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=remolueoend" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jsehull"><img src="https://avatars.githubusercontent.com/u/9935383?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jesse Hull</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jsehull" title="Code">💻</a> <a href="#a11y-jsehull" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/awarrier99"><img src="https://avatars.githubusercontent.com/u/17476235?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ashvin Warrier</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=awarrier99" title="Code">💻</a></td>
    <td align="center"><a href="https://galvingao.com/"><img src="https://avatars.githubusercontent.com/u/12567059?v=4?s=100" width="100px;" alt=""/><br /><sub><b>GalvinGao</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=GalvinGao" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/bianca-sparxs"><img src="https://avatars.githubusercontent.com/u/33003148?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Bianca Sparxs</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=bianca-sparxs" title="Code">💻</a></td>
    <td align="center"><a href="https://www.github.com/aze3ma"><img src="https://avatars.githubusercontent.com/u/6822318?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mahmoud Abdulazim</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=aze3ma" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/davesteinberg"><img src="https://avatars.githubusercontent.com/u/3935584?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dave Steinberg</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=davesteinberg" title="Code">💻</a></td>
    <td align="center"><a href="https://seongryoo.github.io"><img src="https://avatars.githubusercontent.com/u/106095943?s=96&v=4?s=100" width="100px;" alt=""/><br /><sub><b>Seong-Hyun Ryoo</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=shryoo-ibm" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/pratikkarad"><img src="https://avatars.githubusercontent.com/u/32093370?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Pratik Karad</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=pratikkarad" title="Code">💻</a> <a href="#a11y-pratikkarad" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/gerzonc"><img src="https://avatars.githubusercontent.com/u/36211892?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Gerzon</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=gerzonc" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/guidari"><img src="https://avatars.githubusercontent.com/u/52183462?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Guilherme Datilio Ribeiro</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=guidari" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=guidari" title="Documentation">📖</a> <a href="#a11y-guidari" title="Accessibility">️️️️♿️</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Aguidari" title="Reviewed Pull Requests">👀</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/kubijo"><img src="https://avatars.githubusercontent.com/u/11244314?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Josef Kubíček</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=kubijo" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/SunnyJohal"><img src="https://avatars.githubusercontent.com/u/19283532?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sunny Johal</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=SunnyJohal" title="Code">💻</a></td>
    <td align="center"><a href="http://www.steveblackonline.com/"><img src="https://avatars.githubusercontent.com/u/7853451?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Steven Black</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sjbeatle" title="Code">💻</a> <a href="#a11y-sjbeatle" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/mrkjdy"><img src="https://avatars.githubusercontent.com/u/32761859?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mark Judy</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mrkjdy" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/anton-tsymuk-viacomcbs"><img src="https://avatars.githubusercontent.com/u/112623876?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anton Tsymuk</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=anton-tsymuk-viacomcbs" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/modaslam"><img src="https://avatars.githubusercontent.com/u/33179527?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mohammed Aslam P. A.</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=modaslam" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=modaslam" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/tongyy"><img src="https://avatars.githubusercontent.com/u/24784725?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Tony ZL</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=tongyy" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/tulivlk"><img src="https://avatars.githubusercontent.com/u/67226666?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Petr Kadlec</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=tulivlk" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/djragsdale"><img src="https://avatars.githubusercontent.com/u/4396766?v=4?s=100" width="100px;" alt=""/><br /><sub><b>David Ragsdale</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=djragsdale" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/haocheng6"><img src="https://avatars.githubusercontent.com/u/7645930?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hao Cheng</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=haocheng6" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/cordesmj"><img src="https://avatars.githubusercontent.com/u/7409239?v=4?s=100" width="100px;" alt=""/><br /><sub><b>cordesmj</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=cordesmj" title="Code">💻</a></td>
    <td align="center"><a href="https://med-aziz-chebbi.web.app/"><img src="https://avatars.githubusercontent.com/u/60013060?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aziz Chebbi</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=azizChebbi" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/misiekhardcore"><img src="https://avatars.githubusercontent.com/u/58469680?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Michał Konopski</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=misiekhardcore" title="Code">💻</a></td>
    <td align="center"><a href="https://omkarajagunde.web.app/"><img src="https://avatars.githubusercontent.com/u/50138744?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Omkar Ajagunde</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=omkarajagunde" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=omkarajagunde" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/amanlajpal"><img src="https://avatars.githubusercontent.com/u/42869088?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aman Lajpal</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=amanlajpal" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=amanlajpal" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/Nirajsah"><img src="https://avatars.githubusercontent.com/u/51414373?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Niraj Sah</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Nirajsah" title="Code">💻</a></td>
    <td align="center"><a href="https://www.davidpadilla.dev/"><img src="https://avatars.githubusercontent.com/u/25573926?v=4?s=100" width="100px;" alt=""/><br /><sub><b>David Padilla</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=cesardlinx" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/allisonishida"><img src="https://avatars.githubusercontent.com/u/22247062?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Allison Ishida</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=allisonishida" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/alewitt2"><img src="https://avatars.githubusercontent.com/u/48691328?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alex Lewitt</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=alewitt2" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Tresau"><img src="https://avatars.githubusercontent.com/u/148357638?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Tresau</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Tresau" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/danoro96"><img src="https://avatars.githubusercontent.com/u/52253150?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Daniel Castillo</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=danoro96" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/kuri-sun"><img src="https://avatars.githubusercontent.com/u/62743644?v=4?s=100" width="100px;" alt=""/><br /><sub><b>HaRuki</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=kuri-sun" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=kuri-sun" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/matejoslav"><img src="https://avatars.githubusercontent.com/u/8973672?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Matej Ocovsky</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=matejoslav" title="Code">💻</a></td>
    <td align="center"><a href="https://samuelechinellato.com/#/"><img src="https://avatars.githubusercontent.com/u/49278203?v=4?s=100" width="100px;" alt=""/><br /><sub><b>SamChinellato</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=SamChinellato" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/stevenpatrick009"><img src="https://avatars.githubusercontent.com/u/106097350?v=4?s=100" width="100px;" alt=""/><br /><sub><b>stevenpatrick009</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=stevenpatrick009" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/xalc"><img src="https://avatars.githubusercontent.com/u/18441947?v=4?s=100" width="100px;" alt=""/><br /><sub><b>HunterXalc</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=xalc" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/onurozkardes"><img src="https://avatars.githubusercontent.com/u/38096930?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Onur Özkardeş</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=onurozkardes" title="Code">💻</a></td>
    <td align="center"><a href="https://mattborghi.github.io/"><img src="https://avatars.githubusercontent.com/u/11933424?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Matias Borghi</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mattborghi" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/amercury"><img src="https://avatars.githubusercontent.com/u/17834588?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alexandr Ovchinnikov</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=amercury" title="Code">💻</a></td>
    <td align="center"><a href="https://jt-helsinki.github.io/blog/"><img src="https://avatars.githubusercontent.com/u/20871336?v=4?s=100" width="100px;" alt=""/><br /><sub><b>J Thomas</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jt-helsinki" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ggdawson"><img src="https://avatars.githubusercontent.com/u/37080130?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Garrett Dawson</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ggdawson" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=ggdawson" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/dedanade"><img src="https://avatars.githubusercontent.com/u/66811981?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Daniel Adebonojo</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=dedanade" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/mranjana"><img src="https://avatars.githubusercontent.com/u/91003483?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anjana M R</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mranjana" title="Code">💻</a></td>
    <td align="center"><a href="https://cuppajoey.com/"><img src="https://avatars.githubusercontent.com/u/14837881?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Joseph Schultz</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=cuppajoey" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/anjaly0606"><img src="https://avatars.githubusercontent.com/u/99959496?v=4?s=100" width="100px;" alt=""/><br /><sub><b>anjaly0606</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=anjaly0606" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/jesnajoseijk"><img src="https://avatars.githubusercontent.com/u/38346258?v=4?s=100" width="100px;" alt=""/><br /><sub><b>jesnajoseijk</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jesnajoseijk" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Jawahars"><img src="https://avatars.githubusercontent.com/u/4353146?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jawahar S</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Jawahars" title="Code">💻</a></td>
    <td align="center"><a href="https://hollyos.com/"><img src="https://avatars.githubusercontent.com/u/4097509?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Holly Springsteen</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=hollyos" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/2nikhiltom"><img src="https://avatars.githubusercontent.com/2nikhiltom?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nikhil Tomar</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=2nikhiltom" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/aninaantony"><img src="https://avatars.githubusercontent.com/u/164350784?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anina Antony</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=aninaantony" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ahmedsemih"><img src="https://avatars.githubusercontent.com/u/102798814?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ahmed Semih Erkan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ahmedsemih" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ychavoya"><img src="https://avatars.githubusercontent.com/u/7907338?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Yael Chavoya</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ychavoya" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=ychavoya" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><img src="https://avatars.githubusercontent.com/u/37899503?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kilian Collender</b></sub><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Kilian-Collender" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/nandininarayanofficial"><img src="https://avatars.githubusercontent.com/u/165769075?v=4?s=100" width="100px;" alt=""/><br /><sub><b>nandininarayanofficial</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=nandininarayanofficial" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/digiacomo-a"><img src="https://avatars.githubusercontent.com/u/117646602?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Andrea DG</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=digiacomo-a" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/lluisrojass"><img src="https://avatars.githubusercontent.com/u/15043356?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Luis</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=lluisrojass" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/lharrison13"><img src="https://avatars.githubusercontent.com/u/172074450?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Luke Harrison</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=lharrison13" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/tekno0ryder"><img src="https://avatars.githubusercontent.com/u/8721803?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ahmed Alsinan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=tekno0ryder" title="Code">💻</a></td>
    <td align="center"><a href="https://gitlab.com/nevantan"><img src="https://avatars.githubusercontent.com/u/25013998?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nevan Tan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=nevantan" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/AliAldobyan"><img src="https://avatars.githubusercontent.com/u/17975825?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ali Al Dobyan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=AliAldobyan" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Adam-Shea"><img src="https://avatars.githubusercontent.com/u/44814104?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Adam Shea</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Adam-Shea" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/NabeelAyubee"><img src="https://avatars.githubusercontent.com/u/64087875?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Md Nabeel Ayubee</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=NabeelAyubee" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/pamrulla"><img src="https://avatars.githubusercontent.com/u/4942741?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Patan Amrulla Khan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=pamrulla" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=pamrulla" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/neuescodes"><img src="https://avatars.githubusercontent.com/u/9409245?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Noah S.</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=neuescodes" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=neuescodes" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/divya-281"><img src="https://avatars.githubusercontent.com/u/72991264?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Divya G</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=divya-281" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/soumyaraju"><img src="https://avatars.githubusercontent.com/u/41182657?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Soumya Raju</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=soumyaraju" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/mikdhadc"><img src="https://avatars.githubusercontent.com/u/54241506?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mohammed Mikdhad C</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mikdhadc" title="Code">💻</a></td>
    <td align="center"><a href="https://irfadkp.github.io/"><img src="https://avatars.githubusercontent.com/u/54243898?v=4?s=100" width="100px;" alt=""/><br /><sub><b>IRFAD KP</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=irfadkp" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ziyadzulfikar"><img src="https://avatars.githubusercontent.com/u/56788667?v=4?s=100" width="100px;" alt=""/><br /><sub><b>ziyadzulfikar</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ziyadzulfikar" title="Code">💻</a></td>
    <td align="center"><a href="https://irfadkp.github.io/"><img src="https://avatars.githubusercontent.com/u/54243898?v=4?s=100" width="100px;" alt=""/><br /><sub><b>IRFAD KP</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=irfadkp" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/mariat189"><img src="https://avatars.githubusercontent.com/u/74430463?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mariat</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mariat189" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Thamjith"><img src="https://avatars.githubusercontent.com/u/24909620?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Thamjith Thaha</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Thamjith" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Zoe-Gathercole"><img src="https://avatars.githubusercontent.com/u/56911544?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Zoë Gathercole</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Zoe-Gathercole" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/ashna000"><img src="https://avatars.githubusercontent.com/u/12691034?s=96&v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ashna Thomas</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=ashna000" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/a88zach"><img src="https://avatars.githubusercontent.com/u/1724822?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Zach Tindall</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=a88zach" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/vsvsv"><img src="https://avatars.githubusercontent.com/u/9214692?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vsevolod Platunov</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=vsvsv" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/heloiselui"><img src="https://avatars.githubusercontent.com/u/71858203?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Heloise Lui</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=heloiselui" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=heloiselui" title="Documentation">📖</a> <a href="#a11y-heloiselui" title="Accessibility">️️️️♿️</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Aheloiselui" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/nchevsky"><img src="https://avatars.githubusercontent.com/u/3987849?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nick Chevsky</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=nchevsky" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Tweakified"><img src="https://avatars.githubusercontent.com/u/58192912?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Daniel Smith</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Tweakified" title="Code">💻</a> <a href="#a11y-Tweakified" title="Accessibility">️️️️♿️</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=Tweakified" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/enricobguedes"><img src="https://avatars.githubusercontent.com/u/45374536?v=4?s=100" width="100px;" alt=""/><br /><sub><b>enricobguedes</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=enricobguedes" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/gdelory"><img src="https://avatars.githubusercontent.com/u/9974707?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Guillaume Delory</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=gdelory" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Bhas-kar"><img src="https://avatars.githubusercontent.com/u/183294521?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kanchi Bhaskar</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Bhas-kar" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=Bhas-kar" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/maisonsmd"><img src="https://avatars.githubusercontent.com/u/16435155?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Son H. Mai (Mason)</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=maisonsmd" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/warrenmblood"><img src="https://avatars.githubusercontent.com/u/69060697?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Warren Blood</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=warrenmblood" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=warrenmblood" title="Documentation">📖</a> <a href="#a11y-warrenmblood" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/vcherneny"><img src="https://avatars.githubusercontent.com/u/11604315?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vlad Cherneny</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=vcherneny" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/murito"><img src="https://avatars.githubusercontent.com/u/2628140?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Francisco Alcalá</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=murito" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/dkaushik95"><img src="https://avatars.githubusercontent.com/u/8481567?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dishant Kaushik</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=dkaushik95" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://www.linkedin.com/in/sujithcs"><img src="https://avatars.githubusercontent.com/u/43125517?v=4?s=100" width="100px;" alt=""/><br /><sub><b>SUJITH C S</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Code-Suji" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/mariyageorge01"><img src="https://avatars.githubusercontent.com/u/166684108?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mariya George</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mariyageorge01" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/sojinantony01"><img src="https://avatars.githubusercontent.com/u/29255847?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sojin antony</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sojinantony01" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Gopi-Agasthia-S-005CIU744"><img src="https://avatars.githubusercontent.com/u/196181829?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Gopi-Agasthia-S-005CIU744</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Gopi-Agasthia-S-005CIU744" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/sanraj2000"><img src="https://avatars.githubusercontent.com/u/70739919?v=4?s=100" width="100px;" alt=""/><br /><sub><b>sanraj2000</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=sanraj2000" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/NAS-IBM"><img src="https://avatars.githubusercontent.com/u/211188842?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nagarajan Sivaraman</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=NAS-IBM" title="Code">💻</a></td>
    <td align="center"><a href="https://petersandor.name/"><img src="https://avatars.githubusercontent.com/u/3933866?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Peter Šándor</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=petersandor" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/MariaThomson"><img src="https://avatars.githubusercontent.com/u/62303971?s=400&v=4?s=100" width="100px;" alt=""/><br /><sub><b>Maria Thomson</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=MariaThomson" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/AndresCS2025"><img src="https://avatars.githubusercontent.com/u/216789473?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Andres CS</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=AndresCS2025" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/MichCest"><img src="https://avatars.githubusercontent.com/u/3931469?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Michele Payne</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=MichCest" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/AnvarPK"><img src="https://avatars.githubusercontent.com/u/10231751?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anvar</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=AnvarPK" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/maradwan26"><img src="https://avatars.githubusercontent.com/u/132728978?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mahmoud Radwan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=maradwan26" title="Code">💻</a> <a href="https://github.com/carbon-design-system/carbon/commits?author=maradwan26" title="Documentation">📖</a> <a href="#a11y-maradwan26" title="Accessibility">️️️️♿️</a> <a href="https://github.com/carbon-design-system/carbon/pulls?q=is%3Apr+reviewed-by%3Amaradwan26" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/bijoyvalsan"><img src="https://avatars.githubusercontent.com/u/26248649?v=4?s=100" width="100px;" alt=""/><br /><sub><b>bijoy valsan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=bijoyvalsan" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jose-biescas"><img src="https://avatars.githubusercontent.com/u/188625806?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jose Biescas</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jose-biescas" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/anuanto966"><img src="https://avatars.githubusercontent.com/u/216390110?v=4?s=100" width="100px;" alt=""/><br /><sub><b>anuanto966</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=anuanto966" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/F4isalSH"><img src="https://avatars.githubusercontent.com/u/88539362?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Faisal</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=F4isalSH" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/anjju"><img src="https://avatars.githubusercontent.com/u/20580246?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anju Shivan</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=anjju" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/seanhaug"><img src="https://avatars.githubusercontent.com/u/227620549?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sean Haughey</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=seanhaug" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Vignesh-Loganathan-IBM-1"><img src="https://avatars.githubusercontent.com/u/196759586?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vignesh-Loganathan-IBM-1</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Vignesh-Loganathan-IBM-1" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/r1shabhsharma"><img src="https://avatars.githubusercontent.com/u/56930207?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rishabh Sharma</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=r1shabhsharma" title="Code">💻</a></td>
    <td align="center"><a href="http://www.didoo.net/"><img src="https://avatars.githubusercontent.com/u/686239?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Cristiano Rastelli</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=didoo" title="Code">💻</a> <a href="#example-didoo" title="Examples">💡</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/olihf-dematic"><img src="https://avatars.githubusercontent.com/u/225178617?v=4?s=100" width="100px;" alt=""/><br /><sub><b>olihf-dematic</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=olihf-dematic" title="Code">💻</a> <a href="#a11y-olihf-dematic" title="Accessibility">️️️️♿️</a></td>
    <td align="center"><a href="https://github.com/vidhyarbiji"><img src="https://avatars.githubusercontent.com/u/11348409?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vidhya Ravikumar</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=vidhyarbiji" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/mateus037"><img src="https://avatars.githubusercontent.com/u/34143412?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mateus Rodrigues</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=mateus037" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/BiaBiruka"><img src="https://avatars.githubusercontent.com/u/128196689?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Beatriz Parolin</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=BiaBiruka" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jvictorfsilva"><img src="https://avatars.githubusercontent.com/u/68554147?v=4?s=100" width="100px;" alt=""/><br /><sub><b>João Victor</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=jvictorfsilva" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/trumanbutter"><img src="https://avatars.githubusercontent.com/u/32148874?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Truman Butterworth</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=trumanbutter" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/grishma-shah7"><img src="https://avatars.githubusercontent.com/u/87775713?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Grishma Shah</b></sub></a><br /><a href="#a11y-grishma-shah7" title="Accessibility">️️️️♿️</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/Pradumn11"><img src="https://avatars.githubusercontent.com/u/99590317?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Pradumnya Zendphale</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=Pradumn11" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/suniltc-ibm"><img src="https://avatars.githubusercontent.com/u/186133269?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sunil TC</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=suniltc-ibm" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/baadhira"><img src="https://avatars.githubusercontent.com/u/69342013?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Badira P P</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=baadhira" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/harishjanardhanan"><img src="https://avatars.githubusercontent.com/u/32760275?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Harish</b></sub></a><br /><a href="https://github.com/carbon-design-system/carbon/commits?author=harishjanardhanan" title="Documentation">📖</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the
[all-contributors](https://github.com/kentcdodds/all-contributors)
specification. Contributions of any kind welcome!

## 📝 License

Licensed under the [Apache 2.0 License](/LICENSE).
